#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

#define MAXN 200000

typedef struct {
    ll val;
    ll count;
} Pair;

int cmp(const void *a, const void *b) {
    ll x = ((Pair*)a)->val;
    ll y = ((Pair*)b)->val;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

ll count_pairs(ll *arr, int n) {
    Pair p[MAXN];
    int m = 0;
    qsort(arr, n, sizeof(ll), (__compar_fn_t)cmp);

    ll total = 0;
    ll cur = arr[0], cnt = 1;
    for (int i=1;i<n;i++) {
        if (arr[i]==cur) cnt++;
        else {
            total += cnt*(cnt-1)/2;
            cur = arr[i];
            cnt =1;
        }
    }
    total += cnt*(cnt-1)/2;
    return total;
}

int main() {
    int n;
    scanf("%d", &n);
    ll x[MAXN], y[MAXN];
    ll xy[MAXN], xm_y[MAXN];
    for(int i=0;i<n;i++){
        scanf("%lld %lld", &x[i], &y[i]);
        xy[i] = x[i]+y[i];
        xm_y[i] = x[i]-y[i];
    }

    ll total_pairs = count_pairs(xy, n) + count_pairs(xm_y, n);
    ll total_greetings = total_pairs * 2; 

    printf("%lld\n", total_greetings);

    return 0;
}